unit mTestBidoku;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, mBidoku, mAusgabe;

type
  TfrmMain = class(TForm)
    btStartTest: TButton;
    btLoesen: TButton;
    btSpeichern: TButton;
    btLaden: TButton;
    lbLoesbar: TLabel;
    btAnzeigen: TButton;
    procedure btStartTestClick(Sender: TObject);
    procedure btLoesenClick(Sender: TObject);

    procedure btSpeichernClick(Sender: TObject);
    procedure btLadenClick(Sender: TObject);
    procedure memLoesungChange(Sender: TObject);
    procedure btAnzeigenClick(Sender: TObject);
  private
    meinBidoku : TBidoku;
    hAusgabe : TfrmAusgabe;
    procedure FeldZeichnen;

    procedure ZahlenAnSudoku;
    procedure speichern2;
    procedure speichern2Memo;
  public
    edAnzeige : array[0..255] of TEdit;
  end;

var
  frmMain: TfrmMain;

implementation{$R *.dfm}

procedure TfrmMain.FeldZeichnen;
var i:integer;
begin

 for i := 0 to 255 do begin
   edAnzeige[i] := TEdit.Create(frmMain);
   edAnzeige[i].SetBounds(10 + (i mod 16)*20, 10 + (i div 16)* 24,15,15);
   edAnzeige[i].Parent := frmMain;
   edAnzeige[i].Font.Size := 8;
   edAnzeige[i].text := ' ';
 end;

 with frmMain.Canvas do begin
   pen.Width := 2;
   moveto(87, 10); lineto(87, 390);
   moveto(167, 10); lineto(167, 390);
   moveto(247, 10); lineto(247, 390);

   moveto(10, 104); lineto(325, 104);
   moveto(10, 200); lineto(325, 200);
   moveto(10, 296); lineto(325, 296);
 end;  
end;

procedure TfrmMain.ZahlenAnSudoku;
var i : integer; t : string;
begin
  for i := 0 to 255 do begin
    t := edAnzeige[i].Text;
    meinBidoku.Zahlschreiben (i, t);
  end;
end;

procedure TfrmMain.btStartTestClick(Sender: TObject);
begin
  hAusgabe:= TfrmAusgabe.Create(frmMain);
  hAusgabe.Show;
  FeldZeichnen;
end;

procedure TfrmMain.btLoesenClick(Sender: TObject);
var i : integer;
begin
  if meinBidoku <> nil then meinBidoku.Destroy;
  meinBidoku := TBidoku.create(hAusgabe);
  ZahlenAnSudoku;
  case meinBidoku.Loese of
  0: lbLoesbar.Caption:='unlsbar';
  1: lbLoesbar.Caption:='eindeutig';
  else lbLoesbar.Caption:='mehrere Lsg.';
  end;
  {for i := 0 to 255 do
    edAnzeige[i].Text := meinBidoku.ZahlLesen(i); }
  
end;


procedure TfrmMain.btSpeichernClick(Sender: TObject);
var i:integer; s:String; f : TextFile;
begin  {speichern2;}
  s :=''; AssignFile(f, 'Test.bdk');   rewrite(f);
  for i := 0 to 255 do s := s+edAnzeige[i].Text[1];
  writeln(f,s);
  closeFile(f); 
end;

procedure TFrmMain.speichern2;
var i,j,k,l : integer; s:string; f:TextFile;
begin
  s :=''; AssignFile(f, 'Test2.bdk');   Append(f);

  s :='.....................'; writeln(f,s);

  for l := 0 to 3 do begin
    for k := 0 to 3 do begin
      s :='.';
      for j := 0 to 3 do begin
        for i := 0 to 3 do s := s+meinBidoku.ZahlLesen(64*l+16*k+4*j+i);
        s := s + '.';
        end;
      writeln(f,s);
      end;
    s :='.....................'; writeln(f,s);
    end;
  closeFile(f);
end;

procedure TFrmMain.speichern2Memo;
var i,j,k,l : integer; s:string;
begin


  s :='.....................'; hAusgabe.ausgeben(s);

  for l := 0 to 3 do begin
    for k := 0 to 3 do begin
      s :='.';
      for j := 0 to 3 do begin
        for i := 0 to 3 do s := s+meinBidoku.ZahlLesen(16*k+4*j+i);
        s := s + '.';
        end;
      hAusgabe.ausgeben(s);
      end;
    s :='.....................'; hAusgabe.ausgeben(s);
    end;

end;
procedure TfrmMain.btLadenClick(Sender: TObject);
var i:integer; s:String; f : TextFile;
begin
  s :=''; AssignFile(f, 'Test.bdk');   reset(f);readln(f,s);
  for i := 0 to 255 do edAnzeige[i].Text:= s[i+1];
  closeFile(f);
end;

procedure TfrmMain.memLoesungChange(Sender: TObject);
begin
  if meinBidoku <> nil then speichern2Memo;
end;

procedure TfrmMain.btAnzeigenClick(Sender: TObject);
begin
 speichern2Memo
end;

end.
